import os
import sandbox.common.types.client as ctc
from sandbox.projects import resource_types
# noinspection PyProtectedMember
from sandbox.projects.common.build.BuildForAllTask import VersionParameter
import sandbox.projects.common.build.ScriptBuildTask as sbt


class MysqlServerVersion(VersionParameter):
    description = 'mysql server version'
    default_value = '5.6.29'


class BuildMysqlServer(sbt.ScriptBuildTask):
    type = 'BUILD_MYSQLSERVER'
    client_tags = ctc.Tag.LINUX_PRECISE
    input_parameters = [MysqlServerVersion] + sbt.get_script_build_params()
    execution_space = 3000

    # ScriptBuildTask fields
    tool_name = 'mysqld'
    resource_type = resource_types.MYSQLSERVER_PACKAGE

    def run_script(self, version, result_dir_path, env, extra_params=None):
        if 'CC' in env:
            env['PATH'] = '{0}:{1}'.format(os.path.dirname(env['CC']), env['PATH'])
        sbt.ScriptBuildTask.run_script(self, version, result_dir_path, env, extra_params)


__Task__ = BuildMysqlServer
