# coding: utf-8

from sandbox.projects.common.build.CommonBuildTask import CommonBuildTask
import sandbox.common.types.client as ctc
import sandbox.projects.common.constants as consts

from sandbox.projects import resource_types


class BuildNehTask(CommonBuildTask):
    """
        build nehc, - shell console utility, allow make/handle library neh requests
    """

    type = 'BUILD_NEHC'
    execution_space = 50000

    def initCtx(self):
        CommonBuildTask.initCtx(self)
        self.ctx[consts.BUILD_SYSTEM_KEY] = consts.YMAKE_BUILD_SYSTEM

    client_tags = ctc.Tag.Group.LINUX

    TARGET_RESOURCES = (
        (resource_types.NEHC_EXECUTABLE, 'tools/nehc/nehc'),
    )


__Task__ = BuildNehTask
