# -*- coding: utf-8 -*-

import tarfile
from StringIO import StringIO
from time import time

from sandbox.sandboxsdk.svn import Arcadia


def fix_svn_rev(url):
    rev = Arcadia.parse_url(url).revision
    if rev and rev != 'HEAD':
        return url

    rev = Arcadia.info(url)['entry_revision']
    return Arcadia.replace(url, revision=rev)


def add_file_to_tar(tar, name, data, mode=0644, uname='root', gname='ynews'):
    data = str(data)
    ti = tarfile.TarInfo()
    ti.name = name
    ti.mode = mode
    ti.uname = uname
    ti.gname = gname
    ti.type = tarfile.REGTYPE
    ti.size = len(data)
    ti.mtime = time()
    tar.addfile(ti, StringIO(data))
