# -*- coding: utf-8 -*-

from sandbox.sandboxsdk.channel import channel

from sandbox.projects import resource_types
from sandbox.projects.common import breakpad
from sandbox.projects.common.build.CommonBuildTask import CommonBuildTask
from sandbox.projects.common.nanny import nanny


class BuildNewsAppHostDumperd(nanny.ReleaseToNannyTask, CommonBuildTask):
    """
        Build News.Dumperd daemon for AppHost
    """

    type = 'BUILD_NEWS_APPHOST_DUMPERD'

    TARGET_RESOURCES = (
        (resource_types.NEWS_APPHOST_DUMPERD_EXECUTABLE, 'yweb/news/app_host/dumperd/news_apphost_dumperd'),
        (resource_types.EVLOGDUMP_EXECUTABLE, 'yweb/news/app_host/dumperd/evlogdump/evlogdump_dumperd'),
    )

    def do_execute(self):
        CommonBuildTask.do_execute(self)
        res = channel.sandbox.get_resource(self._target_resource_id('news_apphost_dumperd'))
        breakpad.dump_symbols(res)


__Task__ = BuildNewsAppHostDumperd
