# -*- coding: utf-8 -*-

from sandbox.sandboxsdk.channel import channel

from sandbox.projects import resource_types
from sandbox.projects.common import breakpad
from sandbox.projects.common.build.CommonBuildTask import CommonBuildTask
from sandbox.projects.common.nanny import nanny


class BuildNewsAppHostQuotes(nanny.ReleaseToNannyTask, CommonBuildTask):
    """
        Build News.Quotes daemon for AppHost
    """

    type = 'BUILD_NEWS_APPHOST_QUOTES'

    TARGET_RESOURCES = (
        (resource_types.NEWS_APPHOST_QUOTES_EXECUTABLE, 'yweb/news/app_host/quotes/news_apphost_quotes'),
        (resource_types.EVLOGDUMP_EXECUTABLE, 'yweb/news/app_host/quotes/evlogdump/evlogdump_quotes'),
    )

    def do_execute(self):
        CommonBuildTask.do_execute(self)
        res = channel.sandbox.get_resource(self._target_resource_id('news_apphost_quotes'))
        breakpad.dump_symbols(res)


__Task__ = BuildNewsAppHostQuotes
