# -*- coding: utf-8 -*-
from sandbox.sdk2.resource import AbstractResource

from sandbox.projects import resource_types
from sandbox.projects.news.BuildNewsServiceConfigBundleBase import BuildNewsServiceConfigBundleBase


class NEWS_ROUTERD_TEMPLATES_CONFIG(AbstractResource):
    """"""
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = resource_types.news_service_config_releasers


class NEWS_ROUTERD_DYNAMIC_ROBOTS_TXT_CONFIG(AbstractResource):
    """"""
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = resource_types.news_service_config_releasers


class NEWS_ROUTERD_RUN_TEMPLATE(AbstractResource):
    """"""
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = resource_types.news_service_config_releasers


class NEWS_ROUTERD_LEGACY_BROWSERS_CONFIG(AbstractResource):
    """"""
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = resource_types.news_service_config_releasers


class BuildNewsAppHostRouterdServiceConfigBundle(BuildNewsServiceConfigBundleBase):
    """Build bundle with config files and scripts for Nanny service of news app_host routerd"""

    type = "BUILD_NEWS_APPHOST_ROUTERD_SERVICE_CONFIG_BUNDLE"

    NEWS_CONFIG_RESOURCES = {
        "instancectl.conf": resource_types.NEWS_APPHOST_ROUTERD_INSTANCECTL_CONF,
        "templates_config": NEWS_ROUTERD_TEMPLATES_CONFIG,
        "dynamic_robots_txt.json": NEWS_ROUTERD_DYNAMIC_ROBOTS_TXT_CONFIG,
        "run_template.sh": NEWS_ROUTERD_RUN_TEMPLATE,
        "legacy_browsers.json": NEWS_ROUTERD_LEGACY_BROWSERS_CONFIG
    }


__Task__ = BuildNewsAppHostRouterdServiceConfigBundle
