# -*- coding: utf-8 -*-

import os
from sandbox.projects import resource_types
from sandbox.sandboxsdk.paths import make_folder
from sandbox.sandboxsdk.process import run_process

from sandbox.projects.NewsAutoreleasableTask import NewsAutoreleasableTask
from sandbox.projects.NewsAutoreleasableTask import Params as NewsAutoreleasableTaskParams


class BuildNewsBadYandexuids(NewsAutoreleasableTask):
    """
    """
    type = 'BUILD_NEWS_BAD_YANDEXUIDS'

    params = NewsAutoreleasableTaskParams.params

    def do_execute(self):
        workcopy_dir = self.abs_path('workcopy')
        make_folder(workcopy_dir)
        os.chdir(workcopy_dir)

        file_name = 'yandex_cookie_eraser.txt'

        run_process('svn export "svn+ssh://svn.yandex.ru/fuid-keys/trunk/{}" "{}"'.format(file_name, file_name), shell=True)

        resource = self.create_resource(
            description=self.descr,
            resource_path='workcopy/{}'.format(file_name),
            resource_type=resource_types.NEWS_BAD_YANDEXUIDS,
            arch=self.arch,
            attributes={
            },
        )

        self.mark_resource_ready(resource.id)

        return True


__Task__ = BuildNewsBadYandexuids
