# -*- coding: utf-8 -*-

import os
from sandbox.projects import resource_types
from sandbox.sandboxsdk.paths import make_folder
from sandbox.sandboxsdk.process import run_process

from sandbox.projects.NewsAutoreleasableTask import NewsAutoreleasableTask
from sandbox.projects.NewsAutoreleasableTask import Params as NewsAutoreleasableTaskParams

MAX_RETRY_COUNT = 3


class BuildNewsLCookieKeys(NewsAutoreleasableTask):
    """
    """
    type = 'BUILD_NEWS_L_COOKIE_KEYS'

    params = NewsAutoreleasableTaskParams.params

    def do_execute(self):
        workcopy_dir = self.abs_path('workcopy')
        make_folder(workcopy_dir)
        os.chdir(workcopy_dir)

        file_name = 'lrandoms.txt'

        for _ in xrange(MAX_RETRY_COUNT):
            try:
                run_process('curl -vfkL "http://blackbox.yandex.net/{}" > "{}"'.format(file_name, file_name), shell=True)
                break
            except:
                continue
        else:
            raise RuntimeError("Cannot get keys")

        resource = self.create_resource(
            description=self.descr,
            resource_path='workcopy/{}'.format(file_name),
            resource_type=resource_types.NEWS_L_COOKIE_KEYS,
            arch=self.arch,
            attributes={
            },
        )

        self.mark_resource_ready(resource.id)

        return True


__Task__ = BuildNewsLCookieKeys
