import os

from sandbox.projects.common.build.parameters import get_arcadia_params
from sandbox.projects.common.build.YaMake import YaMakeTask, ya_make_build_params

from sandbox.projects.resource_types import NEWS_MR_INDEXER


class BuildNewsMRIndexer(YaMakeTask):
    """ Build news mr_indexer executable"""

    type = 'BUILD_NEWS_MR_INDEXER'
    input_parameters = ya_make_build_params() + get_arcadia_params()

    def get_resources(self):
        resources = {
            'description': 'Build executable',
            'resource_path': os.path.basename(NEWS_MR_INDEXER.arcadia_build_path),
            'resource_type': NEWS_MR_INDEXER,
        }
        return {'project': resources}

    def get_targets(self):
        return [NEWS_MR_INDEXER.arcadia_build_path]

    def get_arts(self):
        return [{'path': NEWS_MR_INDEXER.arcadia_build_path}]


__Task__ = BuildNewsMRIndexer
