# coding: utf-8

import os
import os.path

from sandbox.projects import resource_types
from sandbox.sandboxsdk.process import run_process
from sandbox.sandboxsdk import parameters
from sandbox.sandboxsdk.errors import SandboxTaskFailureError
from sandbox.projects.common.BuildExternalProgramTask import BuildExternalProgramByScript


class BuildNewsMemcached(BuildExternalProgramByScript):
    type = 'BUILD_NEWS_MEMCACHED'

    class ProgramSourceResourceId(parameters.ResourceSelector):
        name = "program_source_resource_id"
        description = "News memcached source"
        resource_type = resource_types.NEWS_MEMCACHED_SOURCE
        required = True

    input_parameters = [ProgramSourceResourceId]

    RESULT_RESOURCE_NAME = 'NEWS_MEMCACHED'
    RESULT_RESOURCE_CLASS = resource_types.NEWS_MEMCACHED

    BUILD_SCRIPT_SVN = 'svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/web/report/scripts/news/build/memcached.sh'

    OS_VERSIONS = ('freebsd-9.0', 'linux-3.2.0')

    def get_sources_resources(self):
        resource_path = self.sync_resource(self.ctx['program_source_resource_id'])

        if not (os.path.isfile(resource_path) and resource_path.endswith(".tar")):
            raise SandboxTaskFailureError(
                "Memcached and libraries resource file does not end with .tar, or resource has no file in its root"
            )

        run_process(['tar', 'xf', resource_path], shell=True)


__Task__ = BuildNewsMemcached
