# coding: utf-8

import os
import os.path

from sandbox.projects import resource_types
from sandbox.sandboxsdk.process import run_process
from sandbox.sandboxsdk import parameters
from sandbox.sandboxsdk.errors import SandboxTaskFailureError
from sandbox.projects.common.BuildExternalProgramTask import BuildExternalProgramByScript


class BuildNewsNginx(BuildExternalProgramByScript):
    type = 'BUILD_NEWS_NGINX'

    class ProgramSourceResourceId(parameters.ResourceSelector):
        name = "program_source_resource_id"
        description = "Nginx source"
        resource_type = resource_types.NGINX_SOURCE
        required = True

    class LibrariesSourcesResourceId(parameters.ResourceSelector):
        name = "libraries_sources_reource_id"
        description = "Nginx libraries"
        resource_type = resource_types.NEWS_NGINX_LIBRARIES_SOURCE
        required = True

    input_parameters = [ProgramSourceResourceId, LibrariesSourcesResourceId]

    RESULT_RESOURCE_NAME = 'NEWS_NGINX'
    RESULT_RESOURCE_CLASS = resource_types.NEWS_NGINX

    BUILD_SCRIPT_SVN = 'svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/web/report/scripts/news/build/nginx.sh'

    OS_VERSIONS = ('linux_ubuntu_12.04_precise')

    def get_sources_resources(self):
        self._get_nginx_source_resource()
        self._get_libraries_resource()

    def _get_nginx_source_resource(self):
        resource_path = self.sync_resource(self.ctx['program_source_resource_id'])

        if not (os.path.isfile(resource_path) and resource_path.endswith(".tar.gz")):
            raise SandboxTaskFailureError(
                "Nginx resource file does not end with .tar.gz, or resource has no file in its root"
            )

        run_process(['cp', resource_path, '.'], shell=True)

    def _get_libraries_resource(self):
        resource_path = self.sync_resource(self.ctx['libraries_sources_reource_id'])

        if not (os.path.isfile(resource_path) and resource_path.endswith(".tar")):
            raise SandboxTaskFailureError(
                "Nginx libraries resource file does not end with .tar, or resource has no file in its root"
            )

        run_process(['tar', 'xf', resource_path], shell=True)


__Task__ = BuildNewsNginx
