# -*- coding: utf-8 -*-

from sandbox.projects import resource_types
from sandbox.projects.news.BuildNewsServiceConfigBundleBase import BuildNewsServiceConfigBundleBase

from sandbox.sdk2.resource import AbstractResource


class NEWS_NGINX_CONFIGS_PRODUCTION(AbstractResource):
    """
    """
    executable = False
    auto_backup = True
    releasable = True
    releasers = resource_types.news_service_config_releasers


class NEWS_NGINX_CONFIGS_TESTING(AbstractResource):
    """
    """
    executable = False
    auto_backup = True
    releasable = True
    releasers = resource_types.news_service_config_releasers


class NEWS_NGINX_CONFIGS_TKVA(AbstractResource):
    """
    """
    executable = False
    auto_backup = True
    releasable = True
    releasers = resource_types.news_service_config_releasers


class NEWS_NGINX_CONFIG_TEMPLATE(AbstractResource):
    """
    """
    executable = False
    auto_backup = True
    releasable = True
    releasers = resource_types.news_service_config_releasers


class NEWS_NGINX_APP_HOST_RESOLVER(AbstractResource):
    """
    """
    executable = False
    auto_backup = True
    releasable = True
    releasers = resource_types.news_service_config_releasers


class NEWS_NGINX_WORKER_LUA_SCRIPT(AbstractResource):
    """
    """
    executable = False
    auto_backup = True
    releasable = True
    releasers = resource_types.news_service_config_releasers


class BuildNewsNginxServiceConfigBundle(BuildNewsServiceConfigBundleBase):
    """Build bundle with config files and scripts for Nanny service of news nginx"""

    type = "BUILD_NEWS_NGINX_SERVICE_CONFIG_BUNDLE"

    NEWS_CONFIG_RESOURCES = {
        "instancectl.conf": resource_types.NEWS_NGINX_INSTANCECTL_CONF,
        "mime.types": resource_types.NEWS_NGINX_MIME_TYPES,
        "iss_hook_notify": resource_types.NEWS_NGINX_ISS_HOOK_NOTIFY,
        "nginx-template.conf": NEWS_NGINX_CONFIG_TEMPLATE,
        "app_host_resolver_run.sh": NEWS_NGINX_APP_HOST_RESOLVER,
        "worker.lua": NEWS_NGINX_WORKER_LUA_SCRIPT,
    }


__Task__ = BuildNewsNginxServiceConfigBundle
