# -*- coding: utf-8 -*-

from sandbox.projects import resource_types
from sandbox.projects.BuildPythonDev import BuildPythonDev
from sandbox.projects.common.environments import SandboxPythonDevEnvironment

import logging
import tarfile
import platform


class NewsPython3Environment(SandboxPythonDevEnvironment):
    resource_type = 'NEWS_PYTHON3'
    STABLE = '3.4.3'


class BuildNewsPython3(BuildPythonDev):
    """Build Python 3 for News"""

    type = "BUILD_NEWS_PYTHON3"

    def _make_resource(self, path):
        logging.info('creating tar.gz file')
        with tarfile.open(self.TGZ_PATH, 'w:gz') as tar:
            tar.add(self.path(path), path)
        self.create_resource(
            description='{} tarball version {}'.format(self.BUILD_DIR, self.ctx['version']),
            resource_path=self.TGZ_PATH,
            resource_type=resource_types.NEWS_PYTHON3,
            attributes={'ttl': 'inf', 'version': self.ctx['version'], 'platform': platform.platform()},
            arch='linux'
        )


__Task__ = BuildNewsPython3
