# -*- coding: utf-8 -*-

import os
from sandbox.projects import resource_types
from sandbox.sandboxsdk.svn import Arcadia
from sandbox.sandboxsdk.task import SandboxTask
from sandbox.sandboxsdk.paths import make_folder
from sandbox.sandboxsdk.parameters import SandboxStringParameter
from sandbox.sandboxsdk.process import run_process


class ReleaseIDParameter(SandboxStringParameter):
    name = 'release_id'
    description = 'Release ID'
    default_value = ''


class BuildNewsRKNViewer(SandboxTask):
    """
        Собирает дистрибутив приложения для news-rkn.viewer.yandex-team.ru
    """
    type = 'BUILD_NEWS_RKN_VIEWER'

    input_parameters = [ReleaseIDParameter]

    def on_execute(self):
        workcopy_dir = self.abs_path('workcopy')
        make_folder(workcopy_dir)
        os.chdir(workcopy_dir)

        release_id = self.ctx.get(ReleaseIDParameter.name)
        data_dir = 'rkn-' + release_id

        Arcadia.export('svn+ssh://arcadia.yandex.ru/arc/tags/news/releases/rkn-viewer/' + release_id + '/arcadia/yweb/news/rkn-viewer', './' + data_dir)
        run_process('tar zcf "%s.tar.gz" "%s"' % (data_dir, data_dir), shell=True)

        resource = self.create_resource(
            description=self.descr,
            resource_path="workcopy/rkn-" + release_id + ".tar.gz",
            resource_type=resource_types.NEWS_RKN_VIEWER,
            arch=self.arch,
            attributes={
                'release_id': release_id,
            },
        )

        self.mark_resource_ready(resource.id)


__Task__ = BuildNewsRKNViewer
