# coding: utf-8

import os
import os.path

from sandbox.projects import resource_types
from sandbox.sandboxsdk.process import run_process
from sandbox.sandboxsdk import parameters

from sandbox.sandboxsdk.errors import SandboxTaskFailureError

from sandbox.projects.common.BuildExternalProgramTask import BuildExternalProgram


class BuildNewsRedisServer(BuildExternalProgram):
    type = 'BUILD_NEWS_REDIS_SERVER'

    class ProgramSourceResourceId(parameters.ResourceSelector):
        name = "program_source_resource_id"
        description = "Redis source"
        resource_type = resource_types.NEWS_REDIS_SERVER_SOURCE
        required = True

    input_parameters = [ProgramSourceResourceId]

    RESULT_RESOURCE_NAME = 'NEWS_REDIS_SERVER'
    RESULT_RESOURCE_CLASS = resource_types.NEWS_REDIS_SERVER

    OS_VERSIONS = ('linux-3.2.0')

    def get_sources_resources(self):
        resource_path = self.sync_resource(self.ctx['program_source_resource_id'])

        if not (os.path.isfile(resource_path) and resource_path.endswith(".tgz")):
            raise SandboxTaskFailureError("Resource file does not end with .tgz or resource with no file in its' root")

        run_process(['tar', '-zxf', resource_path], shell=True)

    def build_binary(self):
        run_process(
            'cd redis/src && make',
            shell=True,
            log_prefix='make',
            outputs_to_one_file=False
        )
        return 'redis/src/redis-server'


__Task__ = BuildNewsRedisServer
