# -*- coding: utf-8 -*-

import os
import re

from sandbox.sdk2.resource import AbstractResource

from sandbox.projects import resource_types
from sandbox.projects.common.build.CommonBuildTask import CommonBuildTask
from sandbox.projects.common.nanny import nanny
import sandbox.projects.common.constants as consts

from sandbox.sandboxsdk.paths import make_folder
from sandbox.sandboxsdk.svn import Arcadia


class NEWS_RELEASER_SERVICE_BUILDER_EXECUTABLE(AbstractResource):
    """"""
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers


class BuildNewsReleaser(nanny.ReleaseToNannyTask, CommonBuildTask):
    """
        Build News.Releaser
    """

    type = 'BUILD_NEWS_RELEASER'

    TARGET_RESOURCES = (
        (resource_types.NEWS_RELEASER_EXECUTABLE, 'yweb/news/releaser/daemon/releaser'),
        (resource_types.NEWS_RELEASER_ENSURE_INDEXES_EXECUTABLE, 'yweb/news/releaser/tools/ensure_indexes/releaser_ensure_indexes'),
        (resource_types.NEWS_RELEASER_BAKE_DEPLOY_GRAPHS_EXECUTABLE, 'yweb/news/releaser/tools/bake_deploy_graphs/releaser_bake_deploy_graphs'),
        (resource_types.NEWS_RELEASER_TEST_LAUNCHES_EXECUTABLE, 'yweb/news/releaser/scripts/test_launches/releaser_test_launches'),
        (resource_types.NEWS_RELEASER_DEPLOY_GRAPH_EXECUTABLE, 'yweb/news/releaser/scripts/deploy_graph/releaser_deploy_graph'),
        (NEWS_RELEASER_SERVICE_BUILDER_EXECUTABLE, 'yweb/news/releaser/scripts/service_builder/releaser_service_builder'),
    )

    def do_execute(self):
        CommonBuildTask.do_execute(self)
        static_url = re.sub(r'(@(?:[0-9]+)?)$', r'/yweb/news/releaser/daemon/static\1', self.ctx.get(consts.ARCADIA_URL_KEY))

        workcopy_dir = self.abs_path('workcopy')
        make_folder(workcopy_dir)
        os.chdir(workcopy_dir)

        data_dir = 'static'

        Arcadia.export(static_url, './' + data_dir)

        resource = self.create_resource(
            description=self.descr,
            resource_path='workcopy/' + data_dir,
            resource_type=resource_types.NEWS_RELEASER_STATIC,
            arch=self.arch,
            attributes={},
        )

        self.mark_resource_ready(resource.id)


__Task__ = BuildNewsReleaser
