# -*- coding: utf-8 -*-

from sandbox.sdk2.resource import AbstractResource

from sandbox.projects import resource_types
from sandbox.projects.news.BuildNewsServiceConfigBundleBase import BuildNewsServiceConfigBundleBase, NewsResourcesArcadiaPath

from sandbox.sandboxsdk.paths import make_folder
from sandbox.sandboxsdk.svn import Arcadia

import re
import os


class NEWS_RELEASER_BUILDABLE_SERVICES(AbstractResource):
    """"""
    executable = False
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = resource_types.news_service_config_releasers


class BuildNewsReleaserServiceConfigBundle(BuildNewsServiceConfigBundleBase):
    """Build bundle with config files and scripts for Nanny service of News.Releaser"""

    type = "BUILD_NEWS_RELEASER_SERVICE_CONFIG_BUNDLE"

    NEWS_CONFIG_RESOURCES = {
        "instancectl.conf": resource_types.NEWS_RELEASER_INSTANCECTL_CONF,
    }

    def on_execute(self):
        BuildNewsServiceConfigBundleBase.on_execute(self)

        workcopy_dir = self.abs_path('workcopy')
        make_folder(workcopy_dir)

        for (repo_dir, local_dir, resource_class) in [
            ('deploy_graphs', 'raw_graphs', resource_types.NEWS_RELEASER_DEPLOY_GRAPHS),
            ('buildable_services', 'buildable_services', NEWS_RELEASER_BUILDABLE_SERVICES),
        ]:
            url = re.sub(r'(/yweb/news/[^@]+)', '/yweb/news/releaser/{}'.format(repo_dir), self.ctx.get(NewsResourcesArcadiaPath.name))

            Arcadia.export(url, os.path.join(workcopy_dir, local_dir))

            resource = self.create_resource(
                description=self.descr,
                resource_path='workcopy/' + local_dir,
                resource_type=resource_class,
                arch=self.arch,
                attributes={},
            )

            self.mark_resource_ready(resource.id)


__Task__ = BuildNewsReleaserServiceConfigBundle
