# -*- coding: utf-8 -*-

from sandbox.projects import resource_types
from sandbox.projects.common.nanny import nanny
from sandbox.projects.common.build.parameters import ArcadiaUrl

from sandbox.sandboxsdk.paths import make_folder
from sandbox.sandboxsdk.process import run_process
from sandbox.sandboxsdk.svn import Arcadia
from sandbox.sandboxsdk.task import SandboxTask

import os
import re


class BuildNewsReportCore(nanny.ReleaseToNannyTask, SandboxTask):
    type = 'BUILD_NEWS_REPORT_CORE'

    input_parameters = (ArcadiaUrl, )

    end_re = r'(@(?:[0-9]+)?)?$'

    def arcadia_subpath(self, path):
        arcadia_url = self.ctx.get(ArcadiaUrl.name)
        out = None

        try:
            out = re.sub(self.end_re, path, arcadia_url)

        except:
            out = arcadia_url + '/' + re.sub(r'( )', path, ' ').strip()

        return out

    def on_execute(self):
        report_url = self.arcadia_subpath(r'/yweb/news/report\1')
        subscription_module_url = self.arcadia_subpath(r'/yweb/news/scripts/lib/perl5/YNews/Subscription.pm\1')

        workcopy_dir = self.abs_path('workcopy')
        make_folder(workcopy_dir)

        report_dir_suffix = 'report-{}'.format(str(self.id))
        report_dir = '{}/{}'.format(workcopy_dir, report_dir_suffix)
        make_folder(report_dir)

        Arcadia.export(report_url, report_dir)

        subscription_module_dir = report_dir + '/lib/YNews'
        make_folder(subscription_module_dir)

        Arcadia.export(subscription_module_url, subscription_module_dir)

        os.chdir(workcopy_dir)

        filename = '{}.tar'.format(report_dir_suffix)
        run_process('tar cf "{}" "{}"'.format(filename, report_dir_suffix), shell=True)

        resource = self.create_resource(
            description=self.descr,
            resource_path='workcopy/' + filename,
            resource_type=resource_types.REPORT_NEWS_CORE_PACKAGE,
            arch=self.arch,
            attributes={},
        )

        self.mark_resource_ready(resource.id)


__Task__ = BuildNewsReportCore
