import os

from sandbox.projects.common.build.parameters import get_arcadia_params
from sandbox.projects.common.build.YaMake import YaMakeTask, ya_make_build_params

from sandbox.projects.resource_types import NEWS_SEARCH_SHARD_BUILDER


class BuildNewsSearchShardBuilder(YaMakeTask):
    """ Build utility for generating search shards from YT tables"""

    type = 'BUILD_NEWS_SEARCH_SHARD_BUILDER'
    input_parameters = ya_make_build_params() + get_arcadia_params()

    def get_resources(self):
        resources = {
            'description': 'Build executable',
            'resource_path': os.path.basename(NEWS_SEARCH_SHARD_BUILDER.arcadia_build_path),
            'resource_type': NEWS_SEARCH_SHARD_BUILDER,
        }
        return {'project': resources}

    def get_targets(self):
        return [NEWS_SEARCH_SHARD_BUILDER.arcadia_build_path]

    def get_arts(self):
        return [{'path': NEWS_SEARCH_SHARD_BUILDER.arcadia_build_path}]


__Task__ = BuildNewsSearchShardBuilder
