# -*- coding: utf-8 -*-

from sandbox.projects import resource_types
from sandbox.projects.news import resources
from sandbox.projects.news.BuildNewsServiceConfigBundleBase import BuildNewsServiceConfigBundleBase


class BuildNewsSlaveNewsdServiceConfigBundle(BuildNewsServiceConfigBundleBase):
    """Build bundle with config files and scripts for Nanny service of slave_newsd"""

    type = "BUILD_NEWS_SLAVE_NEWSD_SERVICE_CONFIG_BUNDLE"

    NEWS_CONFIG_RESOURCES = {
        "apache.ywsearch.cfg": resource_types.NEWS_SLAVE_NEWSD_CONF,
        "instancectl.conf": resource_types.NEWS_SLAVE_NEWSD_INSTANCECTL_CONF,
        "run.sh": resource_types.NEWS_SLAVE_NEWSD_RUNNER,
        "default_index_config": resources.NEWS_DEFAULT_INDEX_CONFIG,
        "slave_newsd_data.conf": resources.NEWS_SLAVE_NEWSD_DATA_CONF,
        "run_template.sh": resources.NEWS_SLAVE_NEWSD_RUN_TEMPLATE
    }


__Task__ = BuildNewsSlaveNewsdServiceConfigBundle
