# -*- coding: utf-8 -*-

import os
from sandbox.projects import resource_types
from sandbox.sandboxsdk.task import SandboxTask
from sandbox.sandboxsdk.paths import make_folder
from sandbox.sandboxsdk.process import run_process
from sandbox.projects.common.nanny import nanny


class BuildNewsUATraitsBrowserXml(nanny.ReleaseToNannyTask, SandboxTask):
    """
    """
    type = 'BUILD_NEWS_UATRAITS_BROWSER_XML'

    def on_execute(self):
        workcopy_dir = self.abs_path('workcopy')
        make_folder(workcopy_dir)
        os.chdir(workcopy_dir)

        file_name = 'browser.xml'

        run_process('curl -vkL "https://github.yandex-team.ru/raw/InfraComponents/uatraits-data/master/data/{}" > "{}"'.format(file_name, file_name), shell=True)

        resource = self.create_resource(
            description=self.descr,
            resource_path='workcopy/{}'.format(file_name),
            resource_type=resource_types.NEWS_UATRAITS_BROWSER_XML,
            arch=self.arch,
            attributes={
            },
        )

        self.mark_resource_ready(resource.id)


__Task__ = BuildNewsUATraitsBrowserXml
