# -*- coding: utf-8 -*-

from sandbox.projects import resource_types
from sandbox.projects.news.BuildNewsServiceConfigBundleBase import BuildNewsServiceConfigBundleBase


class BuildNewsUpperServiceConfigBundle(BuildNewsServiceConfigBundleBase):
    """Build bundle with config files and scripts for Nanny service of news upper (apache)"""

    type = "BUILD_NEWS_UPPER_SERVICE_CONFIG_BUNDLE"

    NEWS_CONFIG_RESOURCES = {
        "collector-deployment.conf": resource_types.NEWS_COLLECTOR_DEPLOYMENT_CONF,
        "collector-tuning.conf": resource_types.NEWS_COLLECTOR_TUNING_CONF,
        "generate_config.sh": resource_types.NEWS_GENERATE_APACHE_HTTPD_CONF_SCRIPT,
        "get_data_runtime.sh": resource_types.NEWS_GET_DATA_RUNTIME_SCRIPT,
        "get_last_resource.py": resource_types.NEWS_GET_LAST_RESOURCE_SCRIPT,
        "httpsearch": resource_types.NEWS_APACHE_HTTPSEARCH_WATCHDOG,
        "install.py": resource_types.NEWS_PREPARE_ARCANAVT_SCRIPT,
        "instancectl.conf": resource_types.NEWS_APACHE_INSTANCECTL_CONF,
        "mk_log_lynks.sh": resource_types.NEWS_MAKE_LOGS_LYNKS_SCRIPT,
        "push-client.conf": resource_types.NEWS_PUSH_CLIENT_CONF,
        "push-client-priemka.conf": resource_types.NEWS_PUSH_CLIENT_PRIEMKA_CONF,
    }


__Task__ = BuildNewsUpperServiceConfigBundle
