import os

from sandbox.projects.common.build.parameters import get_arcadia_params
from sandbox.projects.common.build.YaMake import YaMakeTask, ya_make_build_params
from sandbox.projects.common.nanny.nanny import ReleaseToNannyTask

from sandbox.projects.resource_types import NEWSD_EVLOGDUMP_EXECUTABLE


class BuildNewsdEvlog(ReleaseToNannyTask, YaMakeTask):
    """ Tool for reading evlog generated by slave_newsd"""

    type = 'BUILD_NEWSD_EVLOGDUMP_EXECUTABLE'
    input_parameters = ya_make_build_params() + get_arcadia_params()

    def get_resources(self):
        resources = {
            'description': 'Build executable',
            'resource_path': os.path.basename(NEWSD_EVLOGDUMP_EXECUTABLE.arcadia_build_path),
            'resource_type': NEWSD_EVLOGDUMP_EXECUTABLE,
        }
        return {'project': resources}

    def get_targets(self):
        return [NEWSD_EVLOGDUMP_EXECUTABLE.arcadia_build_path]

    def get_arts(self):
        return [{'path': NEWSD_EVLOGDUMP_EXECUTABLE.arcadia_build_path}]


__Task__ = BuildNewsdEvlog
