import os

from sandbox.projects.common.build.parameters import get_arcadia_params
from sandbox.projects.common.build.YaMake import YaMakeTask, ya_make_build_params

from sandbox.projects.resource_types import NEWSD_STATEWORK


class BuildNewsdStatework(YaMakeTask):
    """ Build newsd_statework executable"""

    type = 'BUILD_NEWSD_STATEWORK'
    input_parameters = ya_make_build_params() + get_arcadia_params()

    def get_resources(self):
        resources = {
            'description': 'Build newsd_statework',
            'resource_path': os.path.join(os.path.basename(NEWSD_STATEWORK.arcadia_build_path), 'newsd_statework'),
            'resource_type': NEWSD_STATEWORK,
        }
        return {'project': resources}

    def get_targets(self):
        return [NEWSD_STATEWORK.arcadia_build_path]

    def get_arts(self):
        return [{'path': NEWSD_STATEWORK.arcadia_build_path}]


__Task__ = BuildNewsdStatework
