# coding: utf-8


import os
import platform

from sandbox.sandboxsdk.task import SandboxTask
from sandbox.sandboxsdk.process import run_process
from sandbox.sandboxsdk.svn import Arcadia
from sandbox.projects import resource_types
import urllib
import shutil


class BuildNinja(SandboxTask):
    '''
    Build ninja executable
    '''
    type = 'BUILD_NINJA'

    ninja_version = '1.0.0'
    ninja_source_url = 'https://github.com/martine/ninja/archive/v%s.tar.gz' % ninja_version
    ninja_patch_version = '1'

    def on_execute(self):
        self.create_resource(
            description="Ninja ",
            resource_path="ninja",
            resource_type=resource_types.NINJA_EXECUTABLE,
            attributes={
                "version": '%s-%s' % (self.ninja_version, self.ninja_patch_version),
                "ttl": "inf",
                "platform": platform.platform()
            }
        )

        ninja_tar_gz_path = self.abs_path('ninja.tgz')

        urllib.urlretrieve(self.ninja_source_url, ninja_tar_gz_path)
        os.chdir(self.abs_path(''))
        run_process(['tar', '-xf', ninja_tar_gz_path],
                    shell=True,
                    log_prefix='tar')
        Arcadia.export(
            "arcadia:/arc/trunk/arcadia/junk/cverutin/ninja_patches/ninja-%s-%s.diff" % (self.ninja_version, self.ninja_patch_version),
            "./ninja-%s.diff" % self.ninja_version
        )

        os.chdir(self.abs_path('ninja-%s' % self.ninja_version))
        patch_fd = open(self.abs_path('ninja-%s.diff' % self.ninja_version))
        run_process(['patch', '-p1'], stdin=patch_fd)
        run_process(['python', './bootstrap.py'])
        shutil.copy(self.abs_path('ninja-%s/ninja' % self.ninja_version), self.abs_path('ninja'))


__Task__ = BuildNinja
