# coding: utf-8

from sandbox.projects import resource_types
from sandbox.projects.BuildNinja import BuildNinja
# noinspection PyProtectedMember
from sandbox.projects.common.build.BuildForAllTask import BuildForAllTask, PlatformsListParameter


class BuildNinjaForAll(BuildForAllTask):
    type = 'BUILD_NINJA_FOR_ALL'
    input_parameters = [PlatformsListParameter]
    release_to = 'sandbox-releases@yandex-team.ru'

    # BuildForAllTask fields
    subtask_type = BuildNinja
    subtask_description = 'Building ninja {version} for {target}'
    resource_type = resource_types.NINJA_EXECUTABLE
    resource_description = 'ninja {version} for {target}'


__Task__ = BuildNinjaForAll
