import os

from sandbox.sandboxsdk.channel import channel

import sandbox.projects.common.build.parameters as build_params

from sandbox.projects.common.build.YaMake import YaMakeTask
from sandbox.projects import resource_types


class BuildNnApplier(YaMakeTask):
    """
        Build DSSM model applier tool
    """

    type = 'BUILD_NN_APPLIER'

    input_parameters = [
        build_params.ArcadiaUrl,
        build_params.BuildSystem,
        build_params.BuildType,
    ]

    TARGET_RESOURCE_TYPES = [
        resource_types.NN_APPLIER_EXECUTABLE,
    ]

    def get_resources(self):
        resources = {}
        for resource_type in self.TARGET_RESOURCE_TYPES:
            resource = {
                'description': resource_type.name,
                'resource_type': resource_type,
                'resource_path': os.path.basename(resource_type.arcadia_build_path),
            }
            resources[resource_type.name] = resource

        return resources

    def get_targets(self):
        return [
            resource_type.arcadia_build_path for resource_type in self.TARGET_RESOURCE_TYPES
        ]

    def get_arts(self):
        return [
            {'path': resource_type.arcadia_build_path} for resource_type in self.TARGET_RESOURCE_TYPES
        ]

    def post_build(self, source_dir, output_dir, pack_dir):
        for resource_type in self.TARGET_RESOURCE_TYPES:
            resources = channel.sandbox.list_resources(resource_type=resource_type, task_id=self.id)
            for resource in resources:
                # Check whether parent task pass resource identifier to fill
                if self.ctx.get(resource_type.name):
                    self.save_parent_task_resource(resource.path, self.ctx[resource_type.name])


__Task__ = BuildNnApplier
