# -*- coding: utf-8 -*-

import sandbox.common.types.client as ctc

from sandbox.sandboxsdk.channel import channel

from sandbox.projects import resource_types
from sandbox.projects.common.build.YaMake import YaMakeTask
import sandbox.projects.common.build.parameters as build_params
from sandbox.projects.common.nanny import nanny


class BuildOntodbRobot(YaMakeTask, nanny.ReleaseToNannyTask):
    """
        Build OntoDB robot
    """

    type = 'BUILD_ONTODB_ROBOT'
    client_tags = ctc.Tag.Group.LINUX
    cores = 24

    input_parameters = [
        build_params.ArcadiaUrl,
        build_params.ArcadiaPatch,
        build_params.DefinitionFlags,
        build_params.TestParameter,
        build_params.UseArcadiaApiFuse,
    ]

    def get_targets(self):
        return [
            'entity/ontodb/robot',
            'zora/client/main',
        ]

    def get_arts(self):
        return [
            {'path': 'dict/ontodb/tools/ontodbfixes/import_fixes/bin/ontodb_import_fixes'},
            {'path': 'entity/ontodb/robot/python_host/python_host'},
            {'path': 'entity/ontodb/robot/tools/afisha_import/bin/afisha_import'},
            {'path': 'entity/ontodb/robot/tools/clean_up_dir/clean_up_dir'},
            {'path': 'entity/ontodb/robot/tools/entity_ans_count/bin/entity_ans_count'},
            {'path': 'entity/ontodb/robot/tools/extdata_import/beyazperde/bin/extdata_beyazperde_import'},
            {'path': 'entity/ontodb/robot/tools/extdata_import/discogs/bin/extdata_discogs_import'},
            {'path': 'entity/ontodb/robot/tools/extdata_import/khl/bin/extdata_khl_import'},
            {'path': 'entity/ontodb/robot/tools/extdata_import/kin/bin/extdata_kin_import'},
            {'path': 'entity/ontodb/robot/tools/extdata_import/wiki/bin/extdata_wiki_import'},
            {'path': 'entity/ontodb/robot/tools/extdata_import/wikidata/bin/extdata_wikidata_import'},
            {'path': 'entity/ontodb/robot/tools/extdata_import/wiki_dumps/bin/extdata_wiki_dumps_import'},
            {'path': 'entity/ontodb/robot/tools/extdata_import/wiki_pagecounts/bin/extdata_wiki_pagecounts_import'},
            # moved to ontodb/tasks (hitman)
            # {'path': 'entity/ontodb/robot/tools/extdata_import/yam/bin/extdata_yam_import'},
            {'path': 'entity/ontodb/robot/tools/extdata_import/yandex_market/bin/extdata_yandex_market_import'},
            {'path': 'entity/ontodb/robot/tools/extdata_import/ytv/bin/extdata_ytv_import'},
            {'path': 'entity/ontodb/robot/tools/get_ontodbfixes/bin/get_ontodbfixes'},
            {'path': 'entity/ontodb/robot/tools/kin_import/trailers/bin/kin_trailers_import'},
            {'path': 'entity/ontodb/robot/tools/kin_import/film_cards/kin_film_cards_import'},
            {'path': 'entity/ontodb/robot/tools/get_ontodb_sprav_images/get_ontodb_sprav_images'},
            {'path': 'entity/ontodb/robot/tools/build_lists/bin/build_lists'},
            {'path': 'entity/ontodb/robot/tools/release_main_delta/bin/release_main_delta'},
            {'path': 'entity/ontodb/robot/tools/fields_diff_counter/bin/fields_diff_counter'},
            {'path': 'entity/ontodb/robot/tools/send_cleanup_stats/bin/send_cleanup_stats'},
            {'path': 'entity/ontodb/robot/tools/send_daily_code_freshness_solomon_sensors/bin/send_daily_code_freshness_solomon_sensors'},
            # enable when all tasks in OBJECTS-9556 will be moved
            # and runtime with deleted code will be released
            # {'path': 'entity/ontodb/robot/tools/send_film_list_sensors/bin/send_film_list_sensors'},
            {'path': 'entity/ontodb/robot/tools/send_kin_solomon_sensors/bin/send_kin_solomon_sensors'},
            {'path': 'entity/ontodb/robot/tools/send_main_delta_time_stats/bin/send_main_delta_time_stats'},
            {'path': 'entity/ontodb/robot/tools/series_structure/bin/series_structure_import'},
            {'path': 'market/idx/tools/pbsncat/bin/pbsncat'},
            {'path': 'zora/rds_zora_client/rds_zora_client'},
            {'path': 'zora/client/main/zoracl'}
        ]

    def get_arts_source(self):
        return [
            {'path': 'entity/ontodb/robot/config.pb.txt'},
            {'path': 'entity/ontodb/robot/scheme.pb.txt'},
        ]

    def get_resources(self):
        project = dict()

        project['resource_type'] = resource_types.ONTODB_ROBOT
        project['description'] = 'OntoDB robot files'
        project['resource_path'] = ''

        return {'project': project}

    def post_build(self, source_dir, output_dir, pack_dir):
        YaMakeTask.post_build(self, source_dir, output_dir, pack_dir)

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask.on_release(self, additional_parameters)
        YaMakeTask.on_release(self, additional_parameters)

    @staticmethod
    def get_zoracl_resource():
        resources = channel.sandbox.list_resources(
            resource_type=resource_types.ZORACL,
            status='READY',
            attribute_name='ontodb_robot',
            attribute_value='custom_zoracl',
            order_by='-id',
            limit=1
        )
        if resources:
            return resources[0]
        return None


__Task__ = BuildOntodbRobot
