# coding: utf-8

import re
import json
import requests
import sandbox.sandboxsdk.task as sdk_task
# from pprint import pprint


NANNY_API = "http://nanny.yandex-team.ru/v2/services/"
SOLOMON_URL = 'http://api.solomon.search.yandex.net/push/json'


class Task(sdk_task.SandboxTask):

    type = "BUILD_STATS_NANNY_SERVICES"

    def send_solomon(self, checks):
        sensors = []
        solomon_sensors_head = {
            'commonLabels': {
                'host': 'nanny',
                'project': 'search',
                'cluster': 'runtime_stats',
                'service': 'cloud'
            },
            'sensors': sensors,
        }
        for i in checks:
            if type(checks[i]) == list:
                count = len(checks[i])
            elif type(checks[i]) == int:
                count = checks[i]
            sensors.append({
                'labels': {
                    'engine': i,
                },
                'value': count
            })
        djson = json.dumps(solomon_sensors_head)
        requests.post(SOLOMON_URL, data=djson, headers={'Content-Type': 'application/json'})

    def get_count_from_nanny(self):
        req_limit = 20
        req_offset = 0
        checks = {
            'iss_services': [],
            'bsconfig_services': [],
            'sandbox_chroot_services': [],
            'docker_chroot_services': [],
            'virt_mode_os_services': [],
            'with_launcher_services': [],
            'mtn_services': [],
            'offline_services': [],
            'online_services': [],
            'old_ipv4_tunnel': []
        }
        nanny_oauth_token = self.get_vault_data('CPLB', 'nanny-oauth-token')
        session = requests.Session()
        session.headers['Authorization'] = 'OAuth {}'.format(nanny_oauth_token)
        session.headers['Content-Type'] = 'application/json'
        response = session.get(NANNY_API, params={'exclude_runtime_attrs': '1'})
        if not response.ok:
            print('Could not count services')
            response.raise_for_status()
        service_count = len(response.json()['result'])
        services_dict = {}
        while req_offset < service_count:
            response = session.get(NANNY_API, params={'skip': req_offset, 'limit': req_limit})
            if not response.ok:
                print('Could not get service descriptions')
                response.raise_for_status()
            services = response.json()['result']

            for service in services:
                services_dict[service['_id']] = {'engine': '', 'status': '', 'use_launcher': '', 'use_mtn': '', 'virt_mode': '', 'chroot_type': '', 'logins': [], 'groups': []}
                services_dict[service['_id']] = {'engine': '', 'status': '', 'use_launcher': '', 'use_ip_tunnel': '', 'use_mtn': '', 'virt_mode': '', 'chroot_type': '', 'logins': [], 'groups': []}
                service_dict = services_dict[service['_id']]
                # print service['_id']
                # if service['_id'] == 'rtc_autoadmin':
                #    pprint(service)
                #    sys.exit(0)
                if service['current_state']['content']['summary']['value'] == 'OFFLINE':
                    service_dict['status'] = 'offline'
                else:
                    service_dict['status'] = 'online'
                if service['runtime_attrs']['content']['engines']['engine_type'] == 'BSCONFIG':
                    service_dict['engine'] = 'bsconfig'
                else:
                    service_dict['engine'] = 'iss'

                if (
                    service['runtime_attrs']['content']['instance_spec'] and
                    service['runtime_attrs']['content']['instance_spec'].get('layersConfig')
                ):
                    if (
                        service['runtime_attrs']['content']['instance_spec']['layersConfig'].get('layer') and
                        service['runtime_attrs']['content']['instance_spec']['layersConfig']['layer'] and
                        service['runtime_attrs']['content']['instance_spec'].get('type') and
                        service['runtime_attrs']['content']['instance_spec']['type'] == 'SANDBOX_LAYERS'
                    ):
                        service_dict['chroot_type'] = 'sandbox'

                    elif (
                        service['runtime_attrs']['content']['instance_spec'].get('dockerImage') and
                        service['runtime_attrs']['content']['instance_spec']['dockerImage']['name'] and
                        service['runtime_attrs']['content']['instance_spec'].get('type') and
                        service['runtime_attrs']['content']['instance_spec']['type'] == 'DOCKER_LAYERS'
                    ):
                        service_dict['chroot_type'] = 'docker'

                if (
                    service['runtime_attrs']['content']['instances'].get('extended_gencfg_groups') and
                    service['runtime_attrs']['content']['instances']['extended_gencfg_groups'].get('network_settings') and
                    service['runtime_attrs']['content']['instances']['extended_gencfg_groups']['network_settings'].get('use_mtn') and
                    service['runtime_attrs']['content']['instances']['extended_gencfg_groups']['network_settings']['use_mtn'] is True
                ):
                    service_dict['use_mtn'] = True

                else:
                    service_dict['use_mtn'] = False

                for file_dict in service['runtime_attrs']['content']['resources']['static_files']:
                    if file_dict['local_path'] == 'instancectl.conf':
                        for line in file_dict['content'].split('\n'):
                            if '#' not in line and re.search('.*launcher .+', line):
                                service_dict['use_launcher'] = True
                            if '#' not in line and re.search('.*virt_mode_os.*', line):
                                service_dict['virt_mode'] = 'os'
                            if '#' not in line and re.search('.*ip_tunnel.*', line):
                                service_dict['use_ip_tunnel'] = True

                if service['runtime_attrs']['content']['instances'].get('extended_gencfg_groups'):
                    service_dict['groups'] = [
                        i['name']
                        for i in service['runtime_attrs']['content']['instances']['extended_gencfg_groups']['groups']
                    ]
                    service_dict['logins'] = service['auth_attrs']['content']['owners']['logins']
            req_offset += req_limit

        for i in services_dict:
            if services_dict[i]['engine'] == 'bsconfig':
                checks['bsconfig_services'].append(i)
            else:
                checks['iss_services'].append(i)
            if services_dict[i]['status'] == 'offline':
                checks['offline_services'].append(i)
            else:
                checks['online_services'].append(i)
            if services_dict[i]['use_launcher'] is True:
                checks['with_launcher_services'].append(i)
            if services_dict[i]['use_ip_tunnel'] is True:
                checks['old_ipv4_tunnel'].append(i)
            if services_dict[i]['virt_mode'] == 'os':
                checks['virt_mode_os_services'].append(i)
            if services_dict[i]['chroot_type'] == 'sandbox':
                checks['sandbox_chroot_services'].append(i)
            elif services_dict[i]['chroot_type'] == 'docker':
                checks['docker_chroot_services'].append(i)
            if services_dict[i]['use_mtn']:
                checks['mtn_services'].append(i)
        return checks

    def on_execute(self):
        checks = self.get_count_from_nanny()
        print(checks)
        self.send_solomon(checks)


__Task__ = Task
