# coding: utf-8

from sandbox import sdk2

import sandbox.projects.resource_types.releasers as releasers

# for backward compatibility, do not use it, use sdk2.Resource instead
AbstractResource = sdk2.resource.AbstractResource


class RTLINE_FRONTEND(AbstractResource):
    """
        RTLine related resource
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = releasers.rtline_releasers
    arcadia_build_path = 'drive/backend/server/server'


class RTLINE_DUMP_TO_INDEXERPROXY(AbstractResource):
    """
        Resource for uploading data to KV
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = releasers.rtline_releasers
    arcadia_build_path = 'rtline/tools/dump_to_indexerproxy/dump_to_indexerproxy'


class RTLINE_TELEMATICS_SERVER(AbstractResource):
    """
        RTLine related resource
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = releasers.rtline_releasers
    arcadia_build_path = 'drive/telematics/server/telematics_server'


class RTLINE_TELEMATICS_TEST_CLIENT(AbstractResource):
    """
        Resource for emulating car using telematics test client
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = releasers.rtline_releasers
    arcadia_build_path = 'drive/telematics/client/client'
