# -*- coding: utf-8 -*-

from sandbox.projects import resource_types

from sandbox.sandboxsdk import task
from sandbox.sandboxsdk.paths import copy_path
from sandbox.sandboxsdk.svn import Arcadia

import sandbox.projects.common.build.parameters as build_params
from sandbox.projects.common.nanny import nanny

import logging
import os


class BuildRTLineConfig(task.SandboxTask, nanny.ReleaseToNannyTask):

    type = 'BUILD_RTLINE_CONFIG'

    input_parameters = [
        build_params.ArcadiaUrl,
    ]

    def on_enqueue(self):
        self.create_resource(
            resource_type=resource_types.RTLINE_LOOP_DATA,
            description=self.description + ' loop data',
            resource_path='loop_data',
        )

        self.create_resource(
            resource_type=resource_types.RTLINE_LOOP_CONF,
            description=self.description + ' loop.conf',
            resource_path='loop.conf',
        )

    def on_execute(self):
        env_folder = self.abs_path('environment')
        Arcadia.export(self.ctx[build_params.ArcadiaUrl.name], env_folder)

        loop_conf_path = os.path.join(env_folder, 'loop.conf')
        loop_data_path = os.path.join(env_folder, 'loop_data')
        if not os.path.exists(loop_conf_path) or not os.path.exists(loop_data_path):
            logging.error('some paths not in svn, svn: %s' % os.listdir(env_folder))
            raise Exception('some paths not in svn')

        copy_path(loop_data_path, self.abs_path('loop_data'))
        copy_path(loop_conf_path, self.abs_path('loop.conf'))

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask.on_release(self, additional_parameters)


__Task__ = BuildRTLineConfig
