# -*- coding: utf-8 -*-

import sandbox.common.types.client as ctc

from sandbox.projects import resource_types
from sandbox.projects.common.build.CommonBuildTask import CommonBuildTask
from sandbox.projects.common.nanny import nanny

import sandbox.projects.common.constants as consts


class BuildRankingMiddleVideosearch(nanny.ReleaseToNannyTask, CommonBuildTask):
    """
        Build ranking middle videoseach binaries
    """

    type = 'BUILD_RANKING_MIDDLE_VIDEOSEARCH'

    client_tags = ctc.Tag.Group.LINUX

    execution_space = 70000

    def initCtx(self):
        CommonBuildTask.initCtx(self)
        self.ctx[consts.BUILD_SYSTEM_KEY] = consts.YMAKE_BUILD_SYSTEM
        self.ctx[consts.BUILD_BUNDLE_KEY] = False

    TARGET_RESOURCE_TYPES = (
        resource_types.VIDEO_RANKING_MIDDLESEARCH_EXECUTABLE,
        resource_types.LOGANALYZE_EXECUTABLE,
        resource_types.EVLOGDUMP_EXECUTABLE,
        resource_types.EVLOGSAMPLE_EXECUTABLE,
        resource_types.EVLOGCACHEHIT_EXECUTABLE,
        resource_types.VIDEO_QUERYDATAVIEWER_EXECUTABLE,
    )


__Task__ = BuildRankingMiddleVideosearch
