# -*- coding: utf-8 -*-

import logging

import sandbox.common.types.client as ctc

from sandbox.projects.common import constants as consts
from sandbox.projects.common.build import parameters as ya_make_parameters
from sandbox.projects.common.build.YaMake import YaMakeTask
from sandbox.projects.common.nanny import nanny
from sandbox.projects.resource_types import RATELIMITER_BIN
from sandbox.sandboxsdk.task import SandboxTask

logger = logging.getLogger(__name__)


class BuildRatelimiter(nanny.ReleaseToNannyTask, YaMakeTask):
    """\
        Build ratelimiter binary
    """

    type = 'BUILD_RATELIMITER'

    client_tags = ctc.Tag.Group.LINUX

    input_parameters = [
        ya_make_parameters.ArcadiaUrl,
        ya_make_parameters.ClearBuild,
        ya_make_parameters.StripBinaries,
        ya_make_parameters.TestParameter,
        ya_make_parameters.TestCustomParameters,
        ya_make_parameters.Sanitize,
        ya_make_parameters.DefinitionFlags,
        ya_make_parameters.CheckReturnCode,
        ya_make_parameters.KeepOn,
        ya_make_parameters.YaTimeout,
    ]

    execution_space = 40 * 1024  # 40Gb will be enough
    required_ram = 4 * 1024
    cores = 24

    def initCtx(self):
        YaMakeTask.initCtx(self)
        self.ctx['result_single_file'] = True
        self.ctx[consts.BUILD_BUNDLE_KEY] = False
        self.ctx['targets'] = 'sup/ratelimiter'
        self.ctx['arts'] = 'sup/ratelimiter/bin/ratelimiter'
        self.ctx['result_rt'] = RATELIMITER_BIN.name

    def get_build_type(self):
        return consts.RELEASE_BUILD_TYPE

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask.on_release(self, additional_parameters)
        SandboxTask.on_release(self, additional_parameters)


__Task__ = BuildRatelimiter
