# -*- coding: utf-8 -*-

import logging
import tarfile
import os
import re


class Utils(object):
    """
    Common functions. In most cases you will not need this functions at all, but they can be usefull sometimes.
    If you look this module's code (help) for a first time, easily skip this class and go to the
    'BaseBuildPythonBundleTask'.
    """

    @staticmethod
    def _create_tar_filter(exclude_patterns):
        """
        Creates function for filtering files by name before adding them to a tar archive.
        """

        def _filter(tarinfo):
            for pattern in exclude_patterns:
                if re.search(pattern, tarinfo.name):
                    return None

            return tarinfo

        return _filter

    @staticmethod
    def pack_archive(data_path, archive_path, excludes=None):
        """
        Create archive from 'data_path'.
        Files can be excluded from archive by 'excludes' patterns.
        Exclude patterns are interpreted as python regular expressions.

        :param data_path: path to file or directory to be archived
        :param archive_path: path to archive file should be created
        :param excludes: list of file exclude patterns.
                         Files matched to the pattern should not be added to archive.
        """
        logging.debug("Packing archive... Data: '{}', archive: '{}', excludes: '{}'".format(data_path,
                                                                                            archive_path,
                                                                                            excludes))
        if excludes is not None:
            _exclude_filter = Utils._create_tar_filter(excludes)
        else:
            _exclude_filter = None

        with tarfile.open(archive_path, "w|gz") as tar:
            if os.path.isdir(data_path):
                tar.add(data_path, ".", filter=_exclude_filter)
            else:
                tar.add(data_path, os.path.basename(data_path), filter=_exclude_filter)
