import json

from sandbox.projects.common.deploy_jupiter import build_replicamap, REPLICAMAP_FILENAME
from sandbox.projects.resource_types import REPLICAMAP

from sandbox.sandboxsdk.task import SandboxTask
from sandbox.sandboxsdk.parameters import SandboxStringParameter


class GroupPrefix(SandboxStringParameter):
    name = 'group_prefix'
    description = 'Gencfg topology group prefix'
    default_value = 'MAN_WEB_PLATINUM_JUPITER_BASE_TEST1'


class GencfgTag(SandboxStringParameter):
    name = 'gencfg_tag'
    description = 'Gencfg topology version'
    default_value = 'tags/stable-92-r84'


class BuildState(SandboxStringParameter):
    name = 'build_state'
    description = 'Build state (timestamp)'
    required = True
    default_value = '20160908-034320'


class BaseState(SandboxStringParameter):
    name = 'base_state'
    description = 'YT state (timestamp)'
    required = True
    default_value = '1473963885'


class BuildReplicamapTest(SandboxTask):
    type = 'BUILD_REPLICAMAPTEST'
    input_parameters = [GroupPrefix, GencfgTag, BuildState]

    def on_execute(self):
        replicamap = build_replicamap(
            self.ctx.get(GroupPrefix.name),
            self.ctx.get(GencfgTag.name),
            self.ctx.get(BuildState.name),
            self.ctx.get(BaseState.name),
            self.id
        )

        with open(REPLICAMAP_FILENAME, 'w') as f:
            f.write(json.dumps(replicamap, indent=4))

        self.create_resource(
            resource_path=REPLICAMAP_FILENAME,
            resource_type=REPLICAMAP,
            description='',
        )


__Task__ = BuildReplicamapTest
