# -*- coding: utf-8 -*-

import os
import json

import sandbox.common.types.client as ctc

from sandbox.projects import resource_types
from sandbox.projects.BuildReport import BuildReport
from sandbox.projects.BuildReport import ArcadiaUrl
from sandbox.sandboxsdk import environments
from sandbox.projects.common.nanny.auto_deploy import AutoNannyDeployTask
from sandbox.projects.common import apihelpers, utils
import sandbox.projects.TestReportUnit as Unit
from sandbox.projects.report.common import ApacheBundleParameter, Project
from sandbox.sandboxsdk.errors import SandboxTaskFailureError
from sandbox.sandboxsdk.channel import channel


class BuildReportCore(AutoNannyDeployTask, BuildReport):
    type = 'BUILD_REPORT_CORE'

    client_tags = ctc.Tag.LINUX_PRECISE

    environment = (environments.SvnEnvironment(),)

    input_parameters = [ArcadiaUrl, Project]

    release_managers = ['sanity', 'video-releases']

    images_release_managers = ['tkatliarova', ]

    execution_space = 1000

    def on_enqueue(self, *args, **kwargs):
        self.choose_resource_type()
        super(BuildReportCore, self).on_enqueue(*args, **kwargs)

    def on_execute(self, *args, **kwargs):
        project = utils.get_or_default(self.ctx, Project)
        self.env_vars[project] = '1'
        self.env_vars["SANDBOX_TASK_ID"] = str(self.id)
        super(BuildReportCore, self).on_execute(*args, **kwargs)

    def choose_resource_type(self):
        project = utils.get_or_default(self.ctx, Project)
        self.report_type = Project.project_to_report.get(project, resource_types.REPORT_CORE_PACKAGE)

    def get_additional_yreport_parameters(self):
        """
            Получить список параметров, с которыми нужно запускать yreport
        """
        return []

    def get_additional_make_parameters(self):
        """
            Получить список параметров, с которыми нужно запускать make
        """
        return ['build.core']

    def get_build_projects(self):
        """
            Получить список собираемых проектов
            @return: собираемые проекты в виде строки
        """
        return 'none'

    def build_report(self):
        os.chdir(self.workcopy_dir)
        # притянуть апач чтобы узнать версию данных
        res = apihelpers.get_last_released_resource(ApacheBundleParameter.resource_type)
        if not res:
            raise SandboxTaskFailureError("Can not find last stable resource %s" % ApacheBundleParameter.resource_type)

        Unit.TestReportUnit.get_apache(res.id, 'apache_bundle')

        super(BuildReportCore, self).build_report()

    def set_runtime_version(self, res_id):
        # апач притянули в методе build_report
        channel.sandbox.set_resource_attribute(
            res_id, 'revision_runtime', Unit.TestReportUnit.runtime_revision('report')
        )

    def get_release_managers(self):
        if self.ctx.get('is_images', False):
            return self.release_managers + self.images_release_managers
        return self.release_managers

    def get_release_managers_json(self):
        return json.dumps(self.get_release_managers())


__Task__ = BuildReportCore
