# -*- coding: utf-8 -*-

import __builtin__

import os
import re

import sandbox.common.types.client as ctc

from sandbox.projects.common.build.BaseSimpleBuildTaskWithPkg import BaseSimpleBuildTaskWithPkg
import sandbox.projects.common.constants as consts

from sandbox.projects import resource_types
from sandbox.sandboxsdk.paths import get_logs_folder
from sandbox.sandboxsdk.svn import Arcadia
from sandbox.sandboxsdk import parameters


def target2field_name(target):
    return 'build_%s' % target


class BuildRotor(BaseSimpleBuildTaskWithPkg):
    type = 'BUILD_ROTOR'

    client_tags = ~ctc.Tag.Group.LINUX | ctc.Tag.LINUX_PRECISE

    TARGET_PATH_TO_NAME_MAP = {
        'yweb/robot/js/rotor/main/rotor': 'rotor'
    }

    TARGET_RESOURCES = (
        (resource_types.ROTOR, 'yweb/robot/js/rotor/main/rotor'),
    )

    RESOURCE_TO_PKG_MAP = {
        'linux': {
            'ROTOR': 'packages/debian/rotor/yandex-search-rotor-rotor-bin',
        },
    }

    class RotorBinaries(parameters.SandboxInfoParameter):
        name = 'info_field'
        description = 'Rotor Binaries'

    input_parameters = BaseSimpleBuildTaskWithPkg.input_parameters + [RotorBinaries]
    for _, path in TARGET_RESOURCES:
        target = TARGET_PATH_TO_NAME_MAP.get(path, os.path.basename(path))
        field_name = target2field_name(target)
        input_parameters.extend([__builtin__.type(
            field_name,
            (parameters.SandboxBoolParameter,),
            dict(name=field_name, description=target),
        )])

    def on_execute(self):

        if self.do_pkg_tasks_exist():
            self.check_pkg_tasks()
            return

        self.ctx[consts.ARCADIA_URL_KEY] = self.normalize_svn_url(self.ctx[consts.ARCADIA_URL_KEY])

        os.putenv('LD_LIBRARY_PATH', '')
        BaseSimpleBuildTaskWithPkg.on_execute(self)

        log_path = get_logs_folder()
        out_str = ''
        if(self.ctx.get('build_rotor')):
            out_str += '"rotor_resource_id":"%s"' % list(self.list_resources('ROTOR'))[0].id

        open(os.path.join(log_path, 'rotor.id.out.txt'), "w").write(out_str)

        if self.are_pkgs_enabled():
            self.mark_resources_ready()
            self.create_pkg_tasks()

    @staticmethod
    def normalize_svn_url(svn_url):
        path = Arcadia.parse_url(svn_url).path
        svn_path = re.sub(r'/arcadia.*', '/arcadia', path, count=1)
        return Arcadia.replace(svn_url, path=svn_path)


__Task__ = BuildRotor
