# -*- coding: utf-8 -*-

import subprocess
import logging
import os
import sandbox.common.types.client as ctc
from sandbox.projects import resource_types
from sandbox.sandboxsdk.task import SandboxTask
from sandbox.sandboxsdk.errors import SandboxTaskFailureError as TaskFail
from sandbox.sandboxsdk.paths import copy_path
from sandbox.projects.common import apihelpers


def run_builder(args, return_codes=0):
    process = subprocess.Popen(args, stderr=subprocess.PIPE)
    (stdout, stderr) = process.communicate()
    process.wait()
    logging.info("builder output:\n%s" % stderr)
    if isinstance(return_codes, int):
        if process.returncode != return_codes:
            raise TaskFail("builder return non expected code {0}".format(process.returncode))
    elif isinstance(return_codes, (list, tuple)):
        if process.returncode not in return_codes:
            raise TaskFail("builder return non expected code {0}".format(process.returncode))
    else:
        raise TaskFail("incorect return_codes paramter type {0}".format(type(return_codes)))

    return process.returncode


class BuildRotorWL(SandboxTask):
    type = "BUILD_ROTOR_WL"

    client_tags = ctc.Tag.LINUX_PRECISE

    description = 'hosts.wl for jsranktrigger'
    execution_space = 16000

    def on_execute(self):
        builder = apihelpers.get_last_resource(resource_types.ROTOR_WL_BUILDER)
        if not builder:
            raise TaskFail('Cannot find resource %s.' % resource_types.ROTOR_WL_BUILDER)

        logging.info("sync resource ROTOR_WL_BUILDER")
        self.sync_resource(builder.id)
        logging.info("wl builder resource %s" % builder)
        executable = self.abs_path('wlbuilder')
        copy_path(os.path.join(builder.path, 'wlbuilder'), executable)
        logging.info("wl builder resource path %s" % executable)
        with open("empty.config.pb.txt", "wb") as f:
            f.close()

        config_fullpath = self.abs_path("empty.config.pb.txt")
        logging.info("config file name %s", config_fullpath)
        logging.info("start build new white list")

        rc = run_builder([executable, '-C', config_fullpath, '-r', 'BUILD_WL'], (0, 10))

        last_whitelist = apihelpers.get_last_resource(resource_types.ROTOR_WHITE_LIST)

        if rc == 10 and last_whitelist:
            logging.info("nothing to rebuild. exit")
            return

        if not last_whitelist:
            logging.info("resource has never been created. download last wl and make resource")

        logging.info("download new white list")
        run_builder([executable, '-C', config_fullpath, '-r', 'DOWNLOAD_WL'])

        resource_filename = 'last.wl'
        resource_path = self.abs_path(resource_filename)
        resource = self._create_resource(
            resource_filename,
            resource_path,
            resource_types.ROTOR_WHITE_LIST
        )

        logging.info("push statistcs")
        run_builder([executable, '-C', config_fullpath, '-r', 'PUSH_STAT'])

        resource.mark_ready()

    def arcadia_info(self):
        return 1, 1, 1


__Task__ = BuildRotorWL
