# -*- coding: utf-8 -*-

from sandbox.projects import resource_types

from sandbox.sandboxsdk import task
from sandbox.sandboxsdk.svn import Arcadia
from sandbox.sandboxsdk.errors import SandboxTaskFailureError
from sandbox.sandboxsdk.environments import VirtualEnvironment
from sandbox.sandboxsdk.channel import channel
from sandbox.projects.common.nanny import nanny

import sandbox.projects.common.build.parameters as build_params

import logging
import os


class BuildRtyserverMapsUserIf(task.SandboxTask, nanny.ReleaseToNannyTask):

    type = 'BUILD_RTYSERVER_MAPS_USER_IF'

    input_parameters = [
        build_params.ArcadiaUrl,
    ]

    def on_enqueue(self):
        self.create_resource(
            resource_type=resource_types.RTYSERVER_MAPS_USER_IF,
            description=self.description,
            resource_path='data',
        )

    def on_execute(self):
        folder = self.abs_path('data')
        Arcadia.export(self.ctx[build_params.ArcadiaUrl.name], folder)

        if not os.path.exists(folder):
            logging.error('some paths not in svn, svn: %s' % os.listdir(folder))
            raise Exception('some paths not in svn')

        logging.info('start building')
        req_path = os.path.join(folder, 'pip-requirements.txt')
        if not os.path.exists(req_path):
            raise SandboxTaskFailureError('requirements not found: %s, dir_content: %s'
                                          % (req_path, os.listdir(folder)))
        env_init_dir = self.path('env')
        with VirtualEnvironment(env_init_dir) as venv:
            venv.pip('pip==9.0.1')
            venv.pip('-r ' + req_path)
            venv.pack_bundle(self.path('env.tar.gz'))

        self._create_resource('Virtual env for cores, ' + self.descr,
                              self.path('env.tar.gz'), resource_types.RTYSERVER_MAPS_USER_IF_ENV)

    def on_release(self, additional_parameters):
        channel.task = self
        nanny.ReleaseToNannyTask.on_release(self, additional_parameters)


__Task__ = BuildRtyserverMapsUserIf
