# coding: utf-8

from sandbox.projects.common.build.YaMake import YaMakeTask

from sandbox.projects.common.build import parameters as build_params
from sandbox.projects.common.nanny import nanny

import sandbox.projects.BuildRviewer.resource_types as resource_types

RESOURCES = {'rviewer_exec': resource_types.RviewerBackendBinary}


class BuildRviewerPy(nanny.ReleaseToNannyTask, YaMakeTask):
    """
    Build rviewer project
    """
    type = 'BUILD_RVIEWER_PY'

    input_parameters = [
        build_params.ArcadiaUrl,
        build_params.BuildType,
        build_params.CheckReturnCode,
        build_params.CheckoutModeParameter,
        build_params.CheckoutParameter,
        build_params.ClearBuild,
    ] + build_params.get_aapi_parameters()

    def get_resources(self):
        return {
            k: {'description': 'rviewer {}'.format(k), 'resource_path': k, 'resource_type': rtype}
            for k, rtype in RESOURCES.iteritems()
        }

    def get_targets(self):
        return ['search/mon/rviewer']

    def get_arts(self):
        return [{'dest': '', 'path': "{}/{}".format(rtype.arcadia_build_path, k)} for k, rtype in RESOURCES.iteritems()]
