# coding: utf-8

from sandbox.projects.common.yappy.base_build_ui import BaseBuildUI
from sandbox.projects.BuildRviewer.resource_types import RviewerUIBundle
from sandbox import sdk2
from sandbox.projects.common.nanny import nanny


class BuildRviewerUI(BaseBuildUI, nanny.ReleaseToNannyTask2, sdk2.Task):

    class Context(BaseBuildUI.Context):
        tests_log_path = None
        tests_results = {}

    @property
    def github_context(self):
        return '[Sandbox] Build and test'

    @property
    def project_conf(self):
        return {
            'github': {
                'report_statuses': self.Parameters.report_github_statuses
            }
        }

    @property
    def bundle_resource_type(self):
        return RviewerUIBundle

    @property
    def bundle_description(self):
        return 'Rviewer UI bundle'

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask2.on_release(self, additional_parameters)
        sdk2.Task.on_release(self, additional_parameters)
