# coding: utf-8

from sandbox import sdk2
from sandbox.projects.resource_types.releasers import marty


class RviewerResource(sdk2.Resource):
    """
    Abstract Rviewer resource.
    """
    releasable = True
    any_arch = False
    releasers = marty
    auto_backup = True


class RviewerBackendBinary(RviewerResource):
    """
    Rviewer backend binary.
    """
    arcadia_build_path = 'search/mon/rviewer'


class RviewerUIBundle(RviewerResource):
    """
    Transpiled, minimized and archived files for Rviewer UI.
    """
