import os
import logging

from sandbox.sandboxsdk import svn
from sandbox.sandboxsdk import task
from sandbox.sandboxsdk import process
from sandbox.sandboxsdk import parameters
from sandbox.sandboxsdk import ssh

from sandbox.projects.common.environments import SandboxJavaJdkEnvironment
from sandbox.projects.common.environments import SandboxMavenEnvironment


class BuildSemanticPublicApi(task.SandboxTask):
    type = 'BUILD_SEMANTIC_PUBLIC_API'

    environment = (
        SandboxJavaJdkEnvironment('1.8.0'),
        SandboxMavenEnvironment('3.2.2'),
    )

    class HgBranch(parameters.SandboxStringParameter):
        name = 'hg_branch'
        description = 'Mercurial branch name'
        default_value = 'release'

    class AuthorLogin(parameters.SandboxStringParameter):
        name = 'author_login'
        description = 'Vault owner'

    class VaultName(parameters.SandboxStringParameter):
        name = 'vault_name'
        description = 'Vault name'

    input_parameters = [
        HgBranch,
        AuthorLogin,
        VaultName
    ]

    def on_execute(self):
        ya = svn.Arcadia.export('arcadia:/arc/trunk/arcadia/ya', os.path.realpath('ya'))

        def hg(*args):
            with ssh.Key(self, self.ctx['author_login'], self.ctx['vault_name']):
                process.run_process([ya, 'tool', 'hg'] + list(args), log_prefix='hg')

        clone_path = self.abs_path('semantic-web')
        hg('clone', 'ssh://' + self.ctx['author_login'] + '@hg.yandex-team.ru/semantic-web/', clone_path, '-r', self.ctx['hg_branch'])

        process.run_process(['mvn',
                     '-s', '../settings.xml',
                     '-f', 'src/assembly/pom.xml',
                     'clean', 'package'],
                    'mvn', shell=True, timeout=10800, check=True, work_dir=clone_path+'/semantic-public-api'
                    )

        if os.path.exists(clone_path):
            logging.warning('111 Damn {} is here!'.format(clone_path))
        else:
            logging.warning('111 Damn {} is NOT here!'.format(clone_path))

        self.create_resource(description='Semantic mf-verifier jars',
                                 resource_path=self.abs_path('semantic-web/semantic-public-api/target/'),
                                 resource_type='SEMANTIC_PUBLIC_API_BINARY',
                                 arch=self.arch)
        if os.path.exists(clone_path):
            logging.warning('222 Damn {} is here!'.format(clone_path))
        else:
            logging.warning('222 Damn {} is NOT here!'.format(clone_path))


__Task__ = BuildSemanticPublicApi
