# coding: utf-8
import platform

from sandbox.projects import resource_types
from sandbox.sandboxsdk import task
from sandbox.sandboxsdk import parameters
from sandbox.sandboxsdk import environments
from sandbox.sandboxsdk.environments import GCCEnvironment
from sandbox.projects.common.environments import PipVirtualenvEnvironment
from sandbox.projects.common.environments import SandboxPythonDevEnvironment
from sandbox.projects.common.environments import SandboxLibMysqlClientEnvironment
from sandbox.sandboxsdk.parameters import SandboxStringParameter
import sandbox.common.types.misc as ctm
import sandbox.common.types.client as ctc


class SentryVersionParameter(SandboxStringParameter):
    name = 'version'
    description = 'Sentry version'
    default_value = '6.4.4'
    required = True


class UseSandboxGCCParameter(parameters.SandboxBoolParameter):
    name = 'use_sandbox_gcc'
    description = 'Use Sandbox GCC'
    default_value = True


class BuildSentryVirtualenv(task.SandboxTask):
    type = 'BUILD_SENTRY_VIRTUALENV'
    dns = ctm.DnsType.DNS64
    client_tags = ctc.Tag.LINUX_PRECISE

    environment = [GCCEnvironment(), PipVirtualenvEnvironment(), SandboxPythonDevEnvironment(), SandboxLibMysqlClientEnvironment()]

    input_parameters = [
        SentryVersionParameter,
        UseSandboxGCCParameter,
    ]

    result_archive_name = 'sentry-virtualenv.tar.gz'
    resource_description = "Sentry python virtualenv"
    resource_type = resource_types.SENTRY_VIRTUALENV

    def on_execute(self):
        with environments.VirtualEnvironment() as venv:
            sentry_version = self.ctx.get('version')
            venv.pip('mysql-python==1.2.5')
            venv.pip('eventlet==0.19.0')
            venv.pip('python-memcached==1.58')
            venv.pip('redis==2.10.5')
            venv.pip('hiredis==0.2.0')
            venv.pip('nydus==0.11.0')
            venv.pip('sentry=={}'.format(sentry_version))
            self.result_dir_name = venv.root_dir
            venv.pack_bundle(self.result_archive_name)

        attrs = {'platform': platform.platform()}

        self.create_resource(description=self.resource_description,
                             resource_path=self.result_archive_name,
                             resource_type=self.resource_type,
                             attributes=attrs)


__Task__ = BuildSentryVirtualenv
