# -*- coding: utf-8 -*-
import sandbox.common.types.client as ctc

from sandbox.projects import resource_types
from sandbox.projects.common.BaseBuildPythonBundleTask import BaseBuildPythonBundleTask
from sandbox.projects.common.BaseBuildPythonBundleTask import GitLocalRepository
from sandbox.projects.common.BaseBuildPythonBundleTask import Utils

from sandbox.sandboxsdk.parameters import SandboxGitUrlParameter


class ServiceTemplateRepositoryPath(SandboxGitUrlParameter):
    name = 'service_template_repository_path'
    description = 'GIT repository with service template'
    default_value = 'https://stash.geo.yandex.net/scm/mr/test.git'


class GitLocalRepositoryNoVerify(GitLocalRepository):
    def _gen_git_command(self, command):
        cmd = "git -c http.sslVerify=false --git-dir '{0}/.git' --work-tree '{0}' {1}".format(self.local_path, command)
        print cmd

        return cmd

    def clone(self, commit=None):
        """
        Clone git repository. Clones repository from remote source to local path.

        :param commit: commit to clone. Can be branch, tag or commit hash (git clone -b <commit>).
                       Defaults to remote repository branch name.
        """
        commit = commit or self.commit

        cmd_pattern = "git clone -c http.sslVerify=false '{repo}' '{path}'"

        cmd = cmd_pattern.format(repo=self.remote_source,
                                 path=self.local_path)

        Utils.run_cmd(cmd, log_message='Cloning git repository: {cmd}', log_prefix='git-clone')

        if commit is None:
            commit = self._get_current_branch()
        else:
            cmd = "checkout '{commit}'".format(commit=commit)
            Utils.run_cmd(self._gen_git_command(cmd), log_message="Checkout ref: {cmd}", log_prefix='git-checkout')

        self.commit = commit


class BuildServiceTemplate(BaseBuildPythonBundleTask):
    type = 'BUILD_SERVICE_TEMPLATE'

    client_tags = ctc.Tag.Group.LINUX

    owners = ['kartvep', 'oxcd8o', 'aesdana', 'nikkraev', 'isharov', ]

    REPO_URL_PARAMETER = ServiceTemplateRepositoryPath

    CODE_NAME = 'service_template'

    RESOURCE_TYPE_VENV_ARCHIVE = resource_types.SERVICE_TEMPLATE_VIRTUAL_ENVIRONMENT_TAR

    def _get_python_code(self):
        """
        Get python code from remote source using Git.
        Set 'self.git' attribute for further usage.
        """
        git_url = self.ctx[self.REPO_URL_PARAMETER.name]
        git_branch = self.ctx[self.REPO_BRANCH_PARAMETER.name]
        local_code_path = self.TEMP_CODE_PATH

        self.git = GitLocalRepositoryNoVerify(remote_source=git_url, local_path=local_code_path)

        # Clone repository
        self.git.clone(git_branch)


__Task__ = BuildServiceTemplate
