# coding: utf-8
import os


import sandbox.projects.common.build.ArcadiaTask
from sandbox.projects import resource_types
from sandbox.sandboxsdk.process import run_process


class BuildShardToSsd(sandbox.projects.common.build.ArcadiaTask.ArcadiaTask):
    '''
    Build script for copying shards to ssd with persistant locking
    '''

    type = 'BUILD_SHARD_TO_SSD'

    def on_execute(self):
        run_process([
            'cp', '-r',
            os.path.join(self.get_arcadia_src_dir(), "tools", "shard_to_ssd", "shard_to_ssd.py"),
            'shard_to_ssd.py'
        ])

        self.create_resource(
            description="shard_to_ssd.py script",
            resource_path='shard_to_ssd.py',
            resource_type=resource_types.SHARD_TO_SSD,
            arch='linux'
        )


__Task__ = BuildShardToSsd
