# -*- coding: utf-8 -*-

from sandbox.sandboxsdk import parameters

from sandbox.projects.common.build.CommonBuildTask import CommonBuildTask

from sandbox.projects import resource_types
from sandbox.projects.common.nanny import nanny


class BuildSiteSuggest(nanny.ReleaseToNannyTask, CommonBuildTask):
    type = 'BUILD_SITE_SUGGEST'

    class InfoField(parameters.SandboxInfoParameter):
        name = 'info_field'
        description = 'Site Suggest'

    class BuildSiteSuggestWebdaemon(parameters.SandboxBoolParameter):
        name = 'build_site_suggest_webdaemon'
        description = 'site_suggest_webdaemon'

    input_parameters = CommonBuildTask.input_parameters + [InfoField, BuildSiteSuggestWebdaemon]

    TARGET_RESOURCES = (
        (resource_types.SITE_SUGGEST_WEBDAEMON,
         resource_types.SITE_SUGGEST_WEBDAEMON.arcadia_build_name,
         resource_types.SITE_SUGGEST_WEBDAEMON.arcadia_build_path),
    )


__Task__ = BuildSiteSuggest
