import os

from sandbox import sdk2
from sandbox.sdk2 import svn
from sandbox.sdk2.helpers import subprocess as sp
from sandbox.common.types import resource as common_resource

from sandbox.projects.common.environments import SandboxJavaJdkEnvironment
from sandbox.projects.common.environments import SandboxMavenEnvironment
from sandbox.projects import resource_types


class SITESEARCH_SEARCHER_BINARY2(sdk2.Resource):
    """
    Sitesearch searcher jars
    """
    releasers = ['iceflame', 'avhaliullin']
    releasable = True


class BuildSitesearchSearcher(sdk2.Task):
    class Requirements(sdk2.Requirements):
        environments = [SandboxJavaJdkEnvironment('1.8.0'), SandboxMavenEnvironment('3.2.2')]

    class Parameters(sdk2.Task.Parameters):
        svn_revision = sdk2.parameters.String('revision', default=None, description='Arcadia revision')
        protoc_res = sdk2.parameters.Resource(
            'protoc_res',
            description='Protoc binary resource',
            resource_type=resource_types.ARCADIA_PROJECT_BINARY,
            state=common_resource.State.READY,
            required=True
        )

    def on_execute(self):
        clone_path = unicode(self.path('sitesearch'))
        svn.Arcadia.checkout('arcadia:/arc/trunk/arcadia/sitesearch', clone_path, revision=self.Parameters.svn_revision)

        protoc = sdk2.ResourceData(self.Parameters.protoc_res)
        os.environ['PATH'] = str(protoc.path) + ":" + os.environ['PATH']

        with sdk2.helpers.ProcessLog(self, logger="mvn") as pl:
            process = sp.Popen(
                [
                    'mvn',
                    '-Djava.net.preferIPv4Stack=false',
                    '-Djava.net.preferIPv6Addresses=true',
                    '-s', 'settings.xml',
                    '-f', 'searcher-assembly',
                    'clean', 'package'
                ],
                cwd=clone_path, stdout=pl.stdout
            )
            process.timeout = 10800
            process.wait()

        resource = SITESEARCH_SEARCHER_BINARY2(self, "Sitesearch searcher jars", unicode(self.path('sitesearch/searcher-assembly/target/assembly/lib/')))
        sdk2.ResourceData(resource).ready()
