import os
import logging

from sandbox.sandboxsdk import svn
from sandbox.sandboxsdk import task
from sandbox.sandboxsdk import process
from sandbox.sandboxsdk import parameters
from sandbox.sandboxsdk import ssh

from sandbox.projects.common.environments import SandboxJavaJdkEnvironment
from sandbox.projects.common.environments import SandboxMavenEnvironment


class BuildSitesearchSuggest(task.SandboxTask):
    type = 'BUILD_SITESEARCH_SUGGEST'

    environment = (
        SandboxJavaJdkEnvironment('1.8.0'),
        SandboxMavenEnvironment('3.2.2'),
    )

    class HgBookmark(parameters.SandboxStringParameter):
        name = 'hg_bookmark'
        description = 'Mercurial bookmark name'
        default_value = 'main'

    class AuthorLogin(parameters.SandboxStringParameter):
        name = 'author_login'
        description = 'Vault owner'

    class VaultName(parameters.SandboxStringParameter):
        name = 'vault_name'
        description = 'Vault name'

    input_parameters = [
        HgBookmark,
        AuthorLogin,
        VaultName
    ]

    def on_execute(self):
        ya = svn.Arcadia.export('arcadia:/arc/trunk/arcadia/ya', os.path.realpath('ya'))

        def hg(*args):
            with ssh.Key(self, self.ctx['author_login'], self.ctx['vault_name']):
                process.run_process([ya, 'tool', 'hg'] + list(args), log_prefix='hg')

        clone_path = self.abs_path('sitesearch')
        hg('clone', 'ssh://' + self.ctx['author_login'] + '@hg.yandex-team.ru/sitesearch/java', clone_path, '-u', self.ctx['hg_bookmark'])

        process.run_process(
            [
                'mvn',
                '-s', 'settings.xml',
                '-f', 'suggest-assembly',
                'clean', 'package',
                '-Djava.net.preferIPv6Addresses=true'
            ],
            'mvn',
            shell=True, timeout=10800, check=True, work_dir=clone_path
        )

        if os.path.exists(clone_path):
            logging.warning('111 Damn {} is here!'.format(clone_path))
        else:
            logging.warning('111 Damn {} is NOT here!'.format(clone_path))

        self.create_resource(
            description='Sitesearch suggest jars',
            resource_path=self.abs_path('sitesearch/suggest-assembly/target/assembly/lib/'),
            resource_type='SITESEARCH_SUGGEST_BINARY',
            arch=self.arch
        )
        if os.path.exists(clone_path):
            logging.warning('222 Damn {} is here!'.format(clone_path))
        else:
            logging.warning('222 Damn {} is NOT here!'.format(clone_path))


__Task__ = BuildSitesearchSuggest
