from sandbox import sdk2
from sandbox.sdk2 import svn
from sandbox.sdk2.helpers import subprocess as sp

from sandbox.projects.common.build import parameters as build_parameters
from sandbox.projects.common.environments import SandboxJavaJdkEnvironment
from sandbox.projects.common.environments import SandboxMavenEnvironment


class SITESEARCH_VIEWER_BINARY2(sdk2.Resource):
    """
    Sitesearch viewer jars
    """
    releasers = ['iceflame', 'avhaliullin']
    releasable = True


class BuildSitesearchViewer(sdk2.Task):
    class Requirements(sdk2.Requirements):
        environments = [SandboxJavaJdkEnvironment('1.8.0'), SandboxMavenEnvironment('3.2.2')]

    class Parameters(sdk2.Task.Parameters):
        svn_revision = sdk2.parameters.String('revision', default=None, description='Arcadia revision')
        arcadia_patch = sdk2.parameters.String(
            "Apply patch (diff file rbtorrent, paste.y-t.ru link or plain text). "
            "Doc: https://nda.ya.ru/3QTTV4",
            default="", multiline=True,
            description=(
                "File paths have to be relative to Sandbox directory, "
                "unless \"Apply patch from RB\" checkbox is set"
            )
        )

    def on_execute(self):
        clone_path = unicode(self.path('sitesearch'))
        svn.Arcadia.checkout('arcadia:/arc/trunk/arcadia/sitesearch', clone_path, revision=self.Parameters.svn_revision)

        arcadia_patch = build_parameters.ArcadiaPatch.cast(self.Parameters.arcadia_patch)
        if arcadia_patch:
            sdk2.svn.Arcadia.apply_patch(
                self.path(),
                arcadia_patch,
                str(self.path())
            )

        with sdk2.helpers.ProcessLog(self, logger="mvn") as pl:
            process = sp.Popen(
                [
                    'mvn',
                    '-Djava.net.preferIPv4Stack=false',
                    '-Djava.net.preferIPv6Addresses=true',
                    '-s', 'settings.xml',
                    '-f', 'viewer-assembly',
                    'clean', 'package'
                ],
                cwd=clone_path, stdout=pl.stdout
            )
            process.timeout = 10800
            process.wait()

        resource = SITESEARCH_VIEWER_BINARY2(self, "Sitesearch viewer jars", unicode(self.path('sitesearch/viewer-assembly/target/assembly/lib/')))
        sdk2.ResourceData(resource).ready()
